'=============================================================
'                      Terms of License
' -----------------------------------------------------------
' Terminabrechnung  2024 by Jens-Christian Wawrczeck
' is licensed under *CC BY-SA 4.0*
' (Creative Commons Attribution-ShareAlike 4.0 International)
' -----------------------------------------------------------
' To view a copy of this license, visit
' https://creativecommons.org/licenses/by-sa/4.0/
'=============================================================

Option Compare Database
Option Explicit

Private Sub Berichtsfu_Format(Cancel As Integer, FormatCount As Integer)
    Dim Oben As Double              'Max-Wert der Zahlenreihe
    Dim Unten As Double             'Min-Wert der Zahlenreihe
    Dim Spanne As Double            'Spannen zw. versch. Max-Min-Werten
    Dim Zentel As Double            'Zentel fr Diagrammhilfslinien
    Dim DIAmax As Double            'Zahlenwert fr Diagramm-Obergrenze
    Dim DIAmin As Double            'Zahlenwert fr Diagramm-Untergrenze
    Dim TextZentel As String
    Dim Nullen As Long
    Dim i As Long
    Dim KastenOben As Long          'Position der Diagrammgrenzen auf der Zeichenflche
    Dim KastenUnten As Long
    Dim KastenLinks As Long
    Dim KastenRechts As Long
    Dim NullLinie As Long
    Dim ZentelLinie As Double
    
    
    'Erst beginnen, wenn der Jahresfilter gesetzt wurde!
    If Me.Filter = "" Then Exit Sub
    
    
    
    KastenOben = 2000               'Absolute Positionen auf dem Papier
    KastenUnten = 6000
    KastenLinks = 1500
    KastenRechts = 9050
    
    
    'Hchster Wert der Zahlenreihe
    If CDbl(Me.WertOben) < 0 Then
        Oben = 0
    Else
        Oben = CDbl(Me.WertOben)
    End If
    
    'Kleinster Wert der Zahlenreihe
    If CDbl(Me.WertUnten) > 0 Then
        Unten = 0
    Else
        Unten = CDbl(Me.WertUnten)
    End If


    Spanne = Abs(Oben)
    If Abs(Unten) > Abs(Oben) Then Spanne = Abs(Unten)
    
    Zentel = Spanne / 10

    
    'Ermittlung des 10ten Teil, "gerunded" auf die erste Ziffer der Zahl
    If Zentel > 1 Then
        TextZentel = CStr(Fix(Zentel))
        Nullen = Len(TextZentel) - 1
        TextZentel = Left(TextZentel, 1)
        For i = 1 To Nullen
            TextZentel = TextZentel & "0"
        Next i
    Else
        TextZentel = CStr(Zentel)
        i = 3
        Do While Mid(TextZentel, i, 1) = "0"
            i = i + 1
        Loop
        TextZentel = Left(TextZentel, i)
    End If
    'auf 2 Nachkommastellen runden, damit keine extrem kleinen Zahlen entstehen
    Zentel = CDbl(Format(CDbl(TextZentel), "#0.00"))
    'Verhinderung einer spteren Division durch Null
    If Zentel = 0 Then Zentel = 0.0001

    
    'Diagrammobergrenze
    If Oben > 0 Then
        '...noch ein "Zentel" dazugeben
        DIAmax = Zentel * (Abs(Fix(Oben / Zentel)) + 1)
    Else
        DIAmax = 0
    End If
    If DIAmax = 0 Then DIAmax = 0.0001

    
    'Diagrammuntergrenze
    If Unten < 0 Then
        '...noch ein "Zentel" dazugeben
        DIAmin = Zentel * (Abs(Fix(Unten / Zentel)) + 1) * (-1)
    Else
        DIAmin = 0
    End If
    If DIAmin = 0 Then DIAmin = 0.0001
    
    
    'Spanne von Diagramm-Obergrenze zu Diagramm-Untergrenze
    Spanne = Abs(DIAmax) + Abs(DIAmin)
    'Position der NullLinie
    NullLinie = KastenOben + (Fix((KastenUnten - KastenOben) * (DIAmax / Spanne)))
    'alle X Punkte eine Hilfslinie
    ZentelLinie = Fix((KastenUnten - KastenOben) * (Zentel / Spanne))
    
    'uere Diagrammgrenzen zeichnen
    Me.ForeColor = RGB(0, 0, 0)                                         'schwarz
    Me.Line (KastenLinks, KastenOben)-(KastenRechts, KastenOben)        'oben
    Me.Line (KastenLinks, KastenUnten)-(KastenRechts, KastenUnten)      'unten
    Me.Line (KastenLinks, KastenOben)-(KastenLinks, KastenUnten)        'links
    Me.Line (KastenRechts, KastenOben)-(KastenRechts, KastenUnten)      'rechts
    
    'NullLinie beschriften
    Me.Achse_Null.Top = NullLinie - 100
    
    'Hilfslinien ber der NullLinie zeichnen
    For i = 1 To 100                                                'bis 20 reicht, zur Sicherheit bis 100
        If (NullLinie - (i * ZentelLinie)) < KastenOben Then Exit For
        Me.Line (KastenLinks, NullLinie - (i * ZentelLinie))-(KastenRechts, NullLinie - (i * ZentelLinie))
        Select Case i
            Case 2
                Me.Achse_Eins.Caption = Format(i * Zentel, "#,##0.00")
                Me.Achse_Eins.Top = (NullLinie - (i * ZentelLinie) - 100)
            Case 4
                Me.Achse_Zwei.Caption = Format(i * Zentel, "#,##0.00")
                Me.Achse_Zwei.Top = (NullLinie - (i * ZentelLinie) - 100)
            Case 6
                Me.Achse_Drei.Caption = Format(i * Zentel, "#,##0.00")
                Me.Achse_Drei.Top = (NullLinie - (i * ZentelLinie) - 100)
            Case 8
                Me.Achse_Vier.Caption = Format(i * Zentel, "#,##0.00")
                Me.Achse_Vier.Top = (NullLinie - (i * ZentelLinie) - 100)
            Case 10
                Me.Achse_Fuenf.Caption = Format(i * Zentel, "#,##0.00")
                Me.Achse_Fuenf.Top = (NullLinie - (i * ZentelLinie) - 100)
            Case 12
                Me.Achse_Sechs.Caption = Format(i * Zentel, "#,##0.00")
                Me.Achse_Sechs.Top = (NullLinie - (i * ZentelLinie) - 100)
            Case 14
                Me.Achse_Sieben.Caption = Format(i * Zentel, "#,##0.00")
                Me.Achse_Sieben.Top = (NullLinie - (i * ZentelLinie) - 100)
            Case 16
                Me.Achse_Acht.Caption = Format(i * Zentel, "#,##0.00")
                Me.Achse_Acht.Top = (NullLinie - (i * ZentelLinie) - 100)
            Case 18
                Me.Achse_Neun.Caption = Format(i * Zentel, "#,##0.00")
                Me.Achse_Neun.Top = (NullLinie - (i * ZentelLinie) - 100)
            Case 20
                Me.Achse_Zehn.Caption = Format(i * Zentel, "#,##0.00")
                Me.Achse_Zehn.Top = (NullLinie - (i * ZentelLinie) - 100)
        End Select
    Next i
    
    'Hilfslinien unter der NullLinie zeichnen
    For i = 1 To 100                                                'bis 20 reicht, zur Sicherheit bis 100
        If (NullLinie + (i * ZentelLinie)) > KastenUnten Then Exit For
        Me.Line (KastenLinks, NullLinie + (i * ZentelLinie))-(KastenRechts, NullLinie + (i * ZentelLinie))
        Select Case i
            Case 2
                Me.Achse_EinsMinus.Caption = Format(i * Zentel * (-1), "#,##0.00")
                Me.Achse_EinsMinus.Top = (NullLinie + (i * ZentelLinie) - 100)
            Case 4
                Me.Achse_ZweiMinus.Caption = Format(i * Zentel * (-1), "#,##0.00")
                Me.Achse_ZweiMinus.Top = (NullLinie + (i * ZentelLinie) - 100)
            Case 6
                Me.Achse_DreiMinus.Caption = Format(i * Zentel * (-1), "#,##0.00")
                Me.Achse_DreiMinus.Top = (NullLinie + (i * ZentelLinie) - 100)
            Case 8
                Me.Achse_VierMinus.Caption = Format(i * Zentel * (-1), "#,##0.00")
                Me.Achse_VierMinus.Top = (NullLinie + (i * ZentelLinie) - 100)
            Case 10
                Me.Achse_FuenfMinus.Caption = Format(i * Zentel * (-1), "#,##0.00")
                Me.Achse_FuenfMinus.Top = (NullLinie + (i * ZentelLinie) - 100)
            Case 12
                Me.Achse_SechsMinus.Caption = Format(i * Zentel * (-1), "#,##0.00")
                Me.Achse_SechsMinus.Top = (NullLinie + (i * ZentelLinie) - 100)
            Case 14
                Me.Achse_SiebenMinus.Caption = Format(i * Zentel * (-1), "#,##0.00")
                Me.Achse_SiebenMinus.Top = (NullLinie + (i * ZentelLinie) - 100)
            Case 16
                Me.Achse_AchtMinus.Caption = Format(i * Zentel * (-1), "#,##0.00")
                Me.Achse_AchtMinus.Top = (NullLinie + (i * ZentelLinie) - 100)
            Case 18
                Me.Achse_NeunMinus.Caption = Format(i * Zentel * (-1), "#,##0.00")
                Me.Achse_NeunMinus.Top = (NullLinie + (i * ZentelLinie) - 100)
            Case 20
                Me.Achse_ZehnMinus.Caption = Format(i * Zentel * (-1), "#,##0.00")
                Me.Achse_ZehnMinus.Top = (NullLinie + (i * ZentelLinie) - 100)
        End Select
    Next i
    
    'Balken fr die Monate Zeichnen
    If CDbl(Me.Monat01.Caption) <> 0 Then
        If CDbl(Me.Monat01.Caption) > 0 Then
            Me.ForeColor = RGB(RGB_PlusRot, RGB_PlusGruen, RGB_PlusBlau)            'Positiv
            Me.Line (KastenLinks + 200, NullLinie - Fix(((NullLinie - KastenOben) * (CDbl(Me.Monat01.Caption) / DIAmax))))-(KastenLinks + 500, NullLinie), , BF
        Else
            Me.ForeColor = RGB(RGB_MinusRot, RGB_MinusGruen, RGB_MinusBlau)         'Negativ
            Me.Line (KastenLinks + 200, NullLinie)-(KastenLinks + 500, NullLinie + Fix(((KastenUnten - NullLinie) * (CDbl(Me.Monat01.Caption) / DIAmin)))), , BF
        End If
    End If
   
    If CDbl(Me.Monat02.Caption) <> 0 Then
        If CDbl(Me.Monat02.Caption) > 0 Then
            Me.ForeColor = RGB(RGB_PlusRot, RGB_PlusGruen, RGB_PlusBlau)            'Positiv
            Me.Line (KastenLinks + 823, NullLinie - Fix(((NullLinie - KastenOben) * (CDbl(Me.Monat02.Caption) / DIAmax))))-(KastenLinks + 1123, NullLinie), , BF
        Else
            Me.ForeColor = RGB(RGB_MinusRot, RGB_MinusGruen, RGB_MinusBlau)         'Negativ
            Me.Line (KastenLinks + 823, NullLinie)-(KastenLinks + 1123, NullLinie + Fix(((KastenUnten - NullLinie) * (CDbl(Me.Monat02.Caption) / DIAmin)))), , BF
        End If
    End If
  
    If CDbl(Me.Monat03.Caption) <> 0 Then
        If CDbl(Me.Monat03.Caption) > 0 Then
            Me.ForeColor = RGB(RGB_PlusRot, RGB_PlusGruen, RGB_PlusBlau)            'Positiv
            Me.Line (KastenLinks + 1445, NullLinie - Fix(((NullLinie - KastenOben) * (CDbl(Me.Monat03.Caption) / DIAmax))))-(KastenLinks + 1745, NullLinie), , BF
        Else
            Me.ForeColor = RGB(RGB_MinusRot, RGB_MinusGruen, RGB_MinusBlau)         'Negativ
            Me.Line (KastenLinks + 1445, NullLinie)-(KastenLinks + 1745, NullLinie + Fix(((KastenUnten - NullLinie) * (CDbl(Me.Monat03.Caption) / DIAmin)))), , BF
        End If
    End If
  
    If CDbl(Me.Monat04.Caption) <> 0 Then
        If CDbl(Me.Monat04.Caption) > 0 Then
            Me.ForeColor = RGB(RGB_PlusRot, RGB_PlusGruen, RGB_PlusBlau)            'Positiv
            Me.Line (KastenLinks + 2068, NullLinie - Fix(((NullLinie - KastenOben) * (CDbl(Me.Monat04.Caption) / DIAmax))))-(KastenLinks + 2368, NullLinie), , BF
        Else
            Me.ForeColor = RGB(RGB_MinusRot, RGB_MinusGruen, RGB_MinusBlau)         'Negativ
            Me.Line (KastenLinks + 2068, NullLinie)-(KastenLinks + 2368, NullLinie + Fix(((KastenUnten - NullLinie) * (CDbl(Me.Monat04.Caption) / DIAmin)))), , BF
        End If
    End If
   
    If CDbl(Me.Monat05.Caption) <> 0 Then
        If CDbl(Me.Monat05.Caption) > 0 Then
            Me.ForeColor = RGB(RGB_PlusRot, RGB_PlusGruen, RGB_PlusBlau)            'Positiv
            Me.Line (KastenLinks + 2690, NullLinie - Fix(((NullLinie - KastenOben) * (CDbl(Me.Monat05.Caption) / DIAmax))))-(KastenLinks + 2990, NullLinie), , BF
        Else
            Me.ForeColor = RGB(RGB_MinusRot, RGB_MinusGruen, RGB_MinusBlau)         'Negativ
            Me.Line (KastenLinks + 2690, NullLinie)-(KastenLinks + 2990, NullLinie + Fix(((KastenUnten - NullLinie) * (CDbl(Me.Monat05.Caption) / DIAmin)))), , BF
        End If
    End If
   
    If CDbl(Me.Monat06.Caption) <> 0 Then
        If CDbl(Me.Monat06.Caption) > 0 Then
            Me.ForeColor = RGB(RGB_PlusRot, RGB_PlusGruen, RGB_PlusBlau)            'Positiv
            Me.Line (KastenLinks + 3314, NullLinie - Fix(((NullLinie - KastenOben) * (CDbl(Me.Monat06.Caption) / DIAmax))))-(KastenLinks + 3614, NullLinie), , BF
        Else
            Me.ForeColor = RGB(RGB_MinusRot, RGB_MinusGruen, RGB_MinusBlau)         'Negativ
            Me.Line (KastenLinks + 3314, NullLinie)-(KastenLinks + 3614, NullLinie + Fix(((KastenUnten - NullLinie) * (CDbl(Me.Monat06.Caption) / DIAmin)))), , BF
        End If
    End If
   
    If CDbl(Me.Monat07.Caption) <> 0 Then
        If CDbl(Me.Monat07.Caption) > 0 Then
            Me.ForeColor = RGB(RGB_PlusRot, RGB_PlusGruen, RGB_PlusBlau)            'Positiv
            Me.Line (KastenLinks + 3936, NullLinie - Fix(((NullLinie - KastenOben) * (CDbl(Me.Monat07.Caption) / DIAmax))))-(KastenLinks + 4236, NullLinie), , BF
        Else
            Me.ForeColor = RGB(RGB_MinusRot, RGB_MinusGruen, RGB_MinusBlau)         'Negativ
            Me.Line (KastenLinks + 3936, NullLinie)-(KastenLinks + 4236, NullLinie + Fix(((KastenUnten - NullLinie) * (CDbl(Me.Monat07.Caption) / DIAmin)))), , BF
        End If
    End If
   
    If CDbl(Me.Monat08.Caption) <> 0 Then
        If CDbl(Me.Monat08.Caption) > 0 Then
            Me.ForeColor = RGB(RGB_PlusRot, RGB_PlusGruen, RGB_PlusBlau)            'Positiv
            Me.Line (KastenLinks + 4559, NullLinie - Fix(((NullLinie - KastenOben) * (CDbl(Me.Monat08.Caption) / DIAmax))))-(KastenLinks + 4859, NullLinie), , BF
        Else
            Me.ForeColor = RGB(RGB_MinusRot, RGB_MinusGruen, RGB_MinusBlau)         'Negativ
            Me.Line (KastenLinks + 4559, NullLinie)-(KastenLinks + 4859, NullLinie + Fix(((KastenUnten - NullLinie) * (CDbl(Me.Monat08.Caption) / DIAmin)))), , BF
        End If
    End If
   
    If CDbl(Me.Monat09.Caption) <> 0 Then
        If CDbl(Me.Monat09.Caption) > 0 Then
            Me.ForeColor = RGB(RGB_PlusRot, RGB_PlusGruen, RGB_PlusBlau)            'Positiv
            Me.Line (KastenLinks + 5182, NullLinie - Fix(((NullLinie - KastenOben) * (CDbl(Me.Monat09.Caption) / DIAmax))))-(KastenLinks + 5482, NullLinie), , BF
        Else
            Me.ForeColor = RGB(RGB_MinusRot, RGB_MinusGruen, RGB_MinusBlau)         'Negativ
            Me.Line (KastenLinks + 5182, NullLinie)-(KastenLinks + 5482, NullLinie + Fix(((KastenUnten - NullLinie) * (CDbl(Me.Monat09.Caption) / DIAmin)))), , BF
        End If
    End If
   
    If CDbl(Me.Monat10.Caption) <> 0 Then
        If CDbl(Me.Monat10.Caption) > 0 Then
            Me.ForeColor = RGB(RGB_PlusRot, RGB_PlusGruen, RGB_PlusBlau)            'Positiv
            Me.Line (KastenLinks + 5805, NullLinie - Fix(((NullLinie - KastenOben) * (CDbl(Me.Monat10.Caption) / DIAmax))))-(KastenLinks + 6105, NullLinie), , BF
        Else
            Me.ForeColor = RGB(RGB_MinusRot, RGB_MinusGruen, RGB_MinusBlau)         'Negativ
            Me.Line (KastenLinks + 5805, NullLinie)-(KastenLinks + 6105, NullLinie + Fix(((KastenUnten - NullLinie) * (CDbl(Me.Monat10.Caption) / DIAmin)))), , BF
        End If
    End If
   
    If CDbl(Me.Monat11.Caption) <> 0 Then
        If CDbl(Me.Monat11.Caption) > 0 Then
            Me.ForeColor = RGB(RGB_PlusRot, RGB_PlusGruen, RGB_PlusBlau)            'Positiv
            Me.Line (KastenLinks + 6427, NullLinie - Fix(((NullLinie - KastenOben) * (CDbl(Me.Monat11.Caption) / DIAmax))))-(KastenLinks + 6727, NullLinie), , BF
        Else
            Me.ForeColor = RGB(RGB_MinusRot, RGB_MinusGruen, RGB_MinusBlau)         'Negativ
            Me.Line (KastenLinks + 6427, NullLinie)-(KastenLinks + 6727, NullLinie + Fix(((KastenUnten - NullLinie) * (CDbl(Me.Monat11.Caption) / DIAmin)))), , BF
        End If
    End If
   
    If CDbl(Me.Monat12.Caption) <> 0 Then
        If CDbl(Me.Monat12.Caption) > 0 Then
            Me.ForeColor = RGB(RGB_PlusRot, RGB_PlusGruen, RGB_PlusBlau)            'Positiv
            Me.Line (KastenLinks + 7050, NullLinie - Fix(((NullLinie - KastenOben) * (CDbl(Me.Monat12.Caption) / DIAmax))))-(KastenLinks + 7350, NullLinie), , BF
        Else
            Me.ForeColor = RGB(RGB_MinusRot, RGB_MinusGruen, RGB_MinusBlau)         'Negativ
            Me.Line (KastenLinks + 7050, NullLinie)-(KastenLinks + 7350, NullLinie + Fix(((KastenUnten - NullLinie) * (CDbl(Me.Monat12.Caption) / DIAmin)))), , BF
        End If
    End If
   
   
   
   
    
    'zum Schluss die Nullinie zeichnen
    Me.ForeColor = RGB(0, 0, 0)                     'schwarz
    Me.Line (KastenLinks, NullLinie - 10)-(KastenRechts, NullLinie + 20), , BF
    
End Sub

Private Sub Detailbereich_Format(Cancel As Integer, FormatCount As Integer)
    'jede zweite Zeile grau hinterlegen
    ZeilenNummer = ZeilenNummer + 1
    If (ZeilenNummer Mod 2) = 0 Then
        Me.ForeColor = RGB(ZeilenGrau, ZeilenGrau, ZeilenGrau)
        Me.Line (0, 0)-(9065, 220), , BF
    End If
    'Zahlenwerte fr die Grafik merken
    'Aber nur, wenn bereits der Jahresfilter gesetzt ist!
    If Me.Filter = "" Then
        Me.Monat01.Caption = 0
        Me.Monat02.Caption = 0
        Me.Monat03.Caption = 0
        Me.Monat04.Caption = 0
        Me.Monat05.Caption = 0
        Me.Monat06.Caption = 0
        Me.Monat07.Caption = 0
        Me.Monat08.Caption = 0
        Me.Monat09.Caption = 0
        Me.Monat10.Caption = 0
        Me.Monat11.Caption = 0
        Me.Monat12.Caption = 0
    Else
        Select Case Me.Monat
            Case 1
                Me.Monat01.Caption = Me.GesamtNetto
            Case 2
                Me.Monat02.Caption = Me.GesamtNetto
            Case 3
                Me.Monat03.Caption = Me.GesamtNetto
            Case 4
                Me.Monat04.Caption = Me.GesamtNetto
            Case 5
                Me.Monat05.Caption = Me.GesamtNetto
            Case 6
                Me.Monat06.Caption = Me.GesamtNetto
            Case 7
                Me.Monat07.Caption = Me.GesamtNetto
            Case 8
                Me.Monat08.Caption = Me.GesamtNetto
            Case 9
                Me.Monat09.Caption = Me.GesamtNetto
            Case 10
                Me.Monat10.Caption = Me.GesamtNetto
            Case 11
                Me.Monat11.Caption = Me.GesamtNetto
            Case 12
                Me.Monat12.Caption = Me.GesamtNetto
        End Select
    End If
End Sub

Private Sub Report_Activate()
    On Error Resume Next
    DoCmd.Close acForm, "Bitte_warten", acSaveYes
End Sub

Private Sub Report_Open(Cancel As Integer)
    SchriftartFuerBerichtEinstellen Me
    Me.ImpFusszeile.Caption = ImpressumBerichtsfuss
    ZeilenNummer = 0

    'aktuelles Whrungsformat des Systems einstellen
    Me.GesamtNetto.Format = "Currency"
    Me.Text70.Format = "Currency"

    Me.Filter = BerichteFilter
    Me.Ueberschrift.Caption = BerichteUeberschrift
    'Me.Jahresfilter.Caption = BerichteJahreswahl
    Me.FilterOn = True
End Sub
